/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.jellyfishingdelight.core;

import club.someoneice.jellyfishingdelight.core.BlockList;
import club.someoneice.jellyfishingdelight.item.Deepasta;
import club.someoneice.jellyfishingdelight.item.DeepastadWithLanternPlantChop;
import club.someoneice.jellyfishingdelight.item.ItemStinkyPatty;
import club.someoneice.jellyfishingdelight.item.Knife;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.registry.ModEffects;

public final class ItemList {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"jellyfishingdelight");
    public static final RegistryObject<Item> LANTERN_PLANT_STICK = ITEMS.register("lantern_plant_stick", () -> ItemList.simpleFood(10, 0.4f, Items.f_42398_.m_7968_(), new MobEffectInstance[0]));
    public static final RegistryObject<Item> CORAL_PLANT_STICK = ITEMS.register("coral_plant_stick", () -> ItemList.simpleFood(10, 0.4f, Items.f_42398_.m_7968_(), new MobEffectInstance[0]));
    public static final RegistryObject<Item> TUBE_PLANT_STICK = ITEMS.register("tube_plant_stick", () -> ItemList.simpleFood(10, 0.4f, Items.f_42398_.m_7968_(), new MobEffectInstance[0]));
    public static final RegistryObject<Item> CHOPED_SEANUT = ITEMS.register("choped_seanut", () -> ItemList.simpleFood(2, 0.1f, new MobEffectInstance[0]));
    public static final RegistryObject<Item> CHOPED_TUBE_PLANT = ITEMS.register("choped_tube_plant", () -> ItemList.simpleFood(2, 0.1f, new MobEffectInstance[0]));
    public static final RegistryObject<Item> CHOPED_LANTERN_PLANT = ITEMS.register("choped_lantern_plant", () -> ItemList.simpleFood(2, 0.1f, new MobEffectInstance[0]));
    public static final RegistryObject<Item> MINI_KRABBY_PATTY = ITEMS.register("mini_krabby_patty", () -> ItemList.simpleFood(4, 0.4f, true, false, new MobEffectInstance[0]));
    public static final RegistryObject<Item> JELLY_KRABBY_PATTY = ITEMS.register("jelly_krabby_patty", () -> ItemList.simpleFood(14, 2.0f, new MobEffectInstance(MobEffects.f_19608_, 7200, 0)));
    public static final RegistryObject<Item> BLUE_JELLY_KRABBY_PATTY = ITEMS.register("blue_jelly_krabby_patty", () -> ItemList.simpleFood(14, 2.0f, new MobEffectInstance(MobEffects.f_19608_, 7200, 0)));
    public static final RegistryObject<Item> BUBBLE_KRABBY_PATTY = ITEMS.register("bubble_krabby_patty", () -> ItemList.simpleFood(6, 1.2f, false, true, new MobEffectInstance(MobEffects.f_19591_, 7200, 0), new MobEffectInstance(MobEffects.f_19608_, 7200, 0)));
    public static final RegistryObject<Item> RED_KRABBY_PATTY = ITEMS.register("red_krabby_patty", () -> ItemList.simpleFood(4, 0.4f, true, true, new MobEffectInstance(MobEffects.f_19600_, 600, 0)));
    public static final RegistryObject<Item> ORANGE_KRABBY_PATTY = ITEMS.register("orange_krabby_patty", () -> ItemList.simpleFood(4, 0.4f, true, true, new MobEffectInstance(MobEffects.f_19607_, 600, 0)));
    public static final RegistryObject<Item> YELLOW_KRABBY_PATTY = ITEMS.register("yellow_krabby_patty", () -> ItemList.simpleFood(4, 0.4f, true, true, new MobEffectInstance(MobEffects.f_19598_, 600, 0)));
    public static final RegistryObject<Item> GREEN_KRABBY_PATTY = ITEMS.register("green_krabby_patty", () -> ItemList.simpleFood(4, 0.4f, true, true, new MobEffectInstance(MobEffects.f_19621_, 600, 0)));
    public static final RegistryObject<Item> BLUE_KRABBY_PATTY = ITEMS.register("blue_krabby_patty", () -> ItemList.simpleFood(4, 0.4f, true, true, new MobEffectInstance(MobEffects.f_19611_, 600, 0)));
    public static final RegistryObject<Item> PURPLE_KRABBY_PATTY = ITEMS.register("purple_krabby_patty", () -> ItemList.simpleFood(4, 0.4f, true, true, new MobEffectInstance(MobEffects.f_19605_, 600, 0)));
    public static final RegistryObject<Item> RAW_KRABBY_PATTY_PATTY = ITEMS.register("raw_krabby_patty_patty", () -> ItemList.simpleFood(1, 0.2f, new MobEffectInstance[0]));
    public static final RegistryObject<Item> KRABBY_PATTY_PATTY = ITEMS.register("krabby_patty_patty", () -> ItemList.simpleFood(2, 0.6f, new MobEffectInstance[0]));
    public static final RegistryObject<Item> STINKY_PATTY = ITEMS.register("stinky_patty", ItemStinkyPatty::new);
    public static final RegistryObject<Item> CHUM_BUCKET = ITEMS.register("chum_bucket", () -> ItemList.simpleFood(8, 0.8f, false, false, false, Items.f_42446_.m_7968_(), new MobEffectInstance(MobEffects.f_19604_, 100, 0), new MobEffectInstance(MobEffects.f_19613_, 3600, 0)));
    public static final RegistryObject<Item> CHUMSTICK = ITEMS.register("chumstick", () -> ItemList.simpleFood(6, 0.4f, new MobEffectInstance(MobEffects.f_19613_, 1200, 0)));
    public static final RegistryObject<Item> DEEPASTA = ITEMS.register("deepasta", Deepasta::new);
    public static final RegistryObject<Item> DEEPASTA_WITH_LANTERN_PLANT_CHOP = ITEMS.register("deepasta_with_lantern_plant_chop", DeepastadWithLanternPlantChop::new);
    public static final RegistryObject<Item> CROAL_STEW = ITEMS.register("croal_stew", () -> ItemList.simpleFood(12, 0.8f, Items.f_42399_.m_7968_(), new MobEffectInstance(MobEffects.f_19619_, 600, 0), new MobEffectInstance(MobEffects.f_19611_, 3600, 0), new MobEffectInstance((MobEffect)ModEffects.NOURISHMENT.get(), 6000, 0)));
    public static final RegistryObject<Item> ROCK_STEW = ITEMS.register("rock_stew", () -> ItemList.simpleFood(12, 0.8f, Items.f_42399_.m_7968_(), new MobEffectInstance(MobEffects.f_216964_, 600, 0), new MobEffectInstance(MobEffects.f_19597_, 3600, 0), new MobEffectInstance((MobEffect)ModEffects.NOURISHMENT.get(), 6000, 0)));
    public static final RegistryObject<Item> PINEAPPLE_STICK = ITEMS.register("pineapple_stick", () -> ItemList.simpleFood(6, 0.3f, Items.f_42398_.m_7968_(), new MobEffectInstance[0]));
    public static final RegistryObject<Item> PINEAPPLE_SODA = ITEMS.register("pineapple_soda", () -> ItemList.simpleFood(6, 0.6f, Items.f_42590_.m_7968_(), new MobEffectInstance[0]));
    public static final RegistryObject<Item> PINEAPPLE_BUN = ITEMS.register("pineapple_bun", () -> ItemList.simpleFood(8, 1.0f, new MobEffectInstance[0]));
    public static final RegistryObject<Item> SEANUT_CHOCOLATE = ITEMS.register("seanut_chocolate", () -> ItemList.simpleFood(8, 1.0f, new MobEffectInstance[0]));
    public static final RegistryObject<Item> SCRAP_METAL_KNIFE = ITEMS.register("scrap_metal_knife", Knife::getScrapMetal);
    public static final RegistryObject<Item> CHROME_METAL_KNIFE = ITEMS.register("chrome_knife", Knife::getChromeMetal);
    public static final RegistryObject<Item> COLORFUL_KRABBY_PATTY = ITEMS.register("colorful_krabby_pattys", () -> new BlockItem((Block)BlockList.COLORFUL_KRABBY_PATTYS.get(), new Item.Properties()));
    public static final RegistryObject<Item> GRILL = ITEMS.register("grill", () -> new BlockItem((Block)BlockList.GRILL.get(), new Item.Properties()));

    private static Item simpleFood(int hunger, float saturation, MobEffectInstance ... effects) {
        return ItemList.simpleFood(hunger, saturation, false, false, effects);
    }

    private static Item simpleFood(int hunger, float saturation, ItemStack itemReturn, MobEffectInstance ... effects) {
        return ItemList.simpleFood(hunger, saturation, false, false, false, itemReturn, effects);
    }

    private static Item simpleFood(int hunger, float saturation, boolean fast, boolean alwaysEat, MobEffectInstance ... effects) {
        return ItemList.simpleFood(hunger, saturation, fast, alwaysEat, false, ItemStack.f_41583_, effects);
    }

    private static Item simpleFood(int hunger, float saturation, boolean fast, boolean alwaysEat, final boolean isDrink, final @Nullable ItemStack bowl, final MobEffectInstance ... effects) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.m_38760_(hunger).m_38758_(saturation);
        if (fast) {
            builder.m_38766_();
        }
        if (alwaysEat) {
            builder.m_38765_();
        }
        return new Item(new Item.Properties().m_41489_(builder.m_38767_())){

            @NotNull
            public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
                if (level.m_5776_()) {
                    return super.m_5922_(stack, level, livingEntity);
                }
                Arrays.stream(effects).filter(Objects::nonNull).map(MobEffectInstance::new).forEach(arg_0 -> ((LivingEntity)livingEntity).m_7292_(arg_0));
                if (Objects.isNull(bowl) || bowl.m_41619_()) {
                    return super.m_5922_(stack, level, livingEntity);
                }
                if (!(livingEntity instanceof Player)) {
                    return super.m_5922_(stack, level, livingEntity);
                }
                Player player = (Player)livingEntity;
                ItemStack itemBowl = bowl.m_41777_();
                if (!player.m_36356_(itemBowl)) {
                    level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), itemBowl));
                }
                return super.m_5922_(stack, level, livingEntity);
            }

            @NotNull
            public UseAnim m_6164_(@NotNull ItemStack stack) {
                return isDrink ? UseAnim.DRINK : UseAnim.EAT;
            }

            public boolean hasCraftingRemainingItem(@NotNull ItemStack stack) {
                return Objects.nonNull(bowl) && !bowl.m_41619_();
            }

            public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
                return this.hasCraftingRemainingItem(itemStack) ? bowl : ItemStack.f_41583_;
            }
        };
    }
}

